/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.dlsfls.legacy;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import com.floragunn.searchguard.support.WildcardMatcher;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EvaluatedDlsFlsConfig {
    public static EvaluatedDlsFlsConfig EMPTY = new EvaluatedDlsFlsConfig(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    private final Map<String, Set<String>> dlsQueriesByIndex;
    private final Map<String, Set<String>> flsByIndex;
    private final Map<String, Set<String>> fieldMaskingByIndex;

    public EvaluatedDlsFlsConfig(Map<String, Set<String>> dlsQueriesByIndex, Map<String, Set<String>> flsByIndex, Map<String, Set<String>> fieldMaskingByIndex) {
        this.dlsQueriesByIndex = Collections.unmodifiableMap(dlsQueriesByIndex);
        this.flsByIndex = Collections.unmodifiableMap(flsByIndex);
        this.fieldMaskingByIndex = Collections.unmodifiableMap(fieldMaskingByIndex);
    }

    public Map<String, Set<String>> getDlsQueriesByIndex() {
        return this.dlsQueriesByIndex;
    }

    public Map<String, Set<String>> getFlsByIndex() {
        return this.flsByIndex;
    }

    public Map<String, Set<String>> getFieldMaskingByIndex() {
        return this.fieldMaskingByIndex;
    }

    public Set<String> getAllQueries() {
        int mapSize = this.dlsQueriesByIndex.size();
        if (mapSize == 0) {
            return Collections.emptySet();
        }
        if (mapSize == 1) {
            return this.dlsQueriesByIndex.values().iterator().next();
        }
        HashSet<String> result = new HashSet<String>();
        for (Set<String> queries : this.dlsQueriesByIndex.values()) {
            result.addAll(queries);
        }
        return result;
    }

    public boolean hasFls() {
        return !this.flsByIndex.isEmpty();
    }

    public boolean hasFieldMasking() {
        return !this.fieldMaskingByIndex.isEmpty();
    }

    public boolean hasDls() {
        return !this.dlsQueriesByIndex.isEmpty();
    }

    public boolean isEmpty() {
        return this.fieldMaskingByIndex.isEmpty() && this.flsByIndex.isEmpty() && this.dlsQueriesByIndex.isEmpty();
    }

    public EvaluatedDlsFlsConfig filter(ActionRequestIntrospector.ResolvedIndices indices) {
        if (indices.isLocalIndicesEmpty()) {
            return EMPTY;
        }
        if (this.isEmpty() || indices.isLocalAll()) {
            return this;
        }
        ImmutableSet allIndices = indices.getLocalAndRemoteIndices();
        return new EvaluatedDlsFlsConfig(this.filter(this.dlsQueriesByIndex, (Set<String>)allIndices), this.filter(this.flsByIndex, (Set<String>)allIndices), this.filter(this.fieldMaskingByIndex, (Set<String>)allIndices));
    }

    public EvaluatedDlsFlsConfig withoutDls() {
        if (!this.hasDls()) {
            return this;
        }
        return new EvaluatedDlsFlsConfig(Collections.emptyMap(), this.flsByIndex, this.fieldMaskingByIndex);
    }

    private Map<String, Set<String>> filter(Map<String, Set<String>> map, Set<String> allIndices) {
        if (allIndices.isEmpty() || map.isEmpty()) {
            return map;
        }
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(map.size());
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            if (!WildcardMatcher.matchAny((String)entry.getKey(), allIndices, (boolean)false)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public String toString() {
        return "EvaluatedDlsFlsConfig [dlsQueriesByIndex=" + this.dlsQueriesByIndex + ", flsByIndex=" + this.flsByIndex + ", fieldMaskingByIndex=" + this.fieldMaskingByIndex + "]";
    }
}

